/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.MACAddress;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.enums.LightStatus;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class PortEvent
extends IPCEvent {
    public EventType type;

    public PortEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        POWER_CHANGED,
        MAC_CHANGED,
        LIGHT_STATUS_CHANGED,
        LIGHT_BLINKED,
        PACKET_RECEIVED,
        PORT_STATUS_CHANGED,
        LINE_PROTOCOL_CHANGED;

    }

    public static class LineProtocolChanged
    extends PortEvent {
        public Boolean portUp;

        public LineProtocolChanged(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.LINE_PROTOCOL_CHANGED;
            this.portUp = (Boolean)ltv.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\tportUp = " + this.portUp;
        }
    }

    public static class PortStatusChanged
    extends PortEvent {
        public Boolean portUp;

        public PortStatusChanged(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.PORT_STATUS_CHANGED;
            this.portUp = (Boolean)ltv.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\tportUp = " + this.portUp;
        }
    }

    public static class PacketReceived
    extends PortEvent {
        public String inType;
        public Integer size;

        public PacketReceived(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.PACKET_RECEIVED;
            this.inType = (String)ltv.getEventParameters().get(0);
            this.size = (Integer)ltv.getEventParameters().get(1);
        }

        public String toString() {
            return super.toString() + "\n\tinType = " + this.inType + "\n\tsize = " + this.size;
        }
    }

    public static class LightBlinked
    extends PortEvent {
        public LightBlinked(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.LIGHT_BLINKED;
        }

        public String toString() {
            return super.toString();
        }
    }

    public static class LightStatusChanged
    extends PortEvent {
        public LightStatus status;

        public LightStatusChanged(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.LIGHT_STATUS_CHANGED;
            this.status = LightStatus.fromIntValue((Integer)ltv.getEventParameters().get(0));
        }

        public String toString() {
            return super.toString() + "\n\tstatus = " + (Object)((Object)this.status);
        }
    }

    public static class MacChanged
    extends PortEvent {
        public MACAddress newMac;
        public MACAddress oldMac;

        public MacChanged(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.MAC_CHANGED;
            this.newMac = (MACAddress)ltv.getEventParameters().get(0);
            this.oldMac = (MACAddress)ltv.getEventParameters().get(1);
        }

        public String toString() {
            return super.toString() + "\n\tnewMac = " + this.newMac + "\n\toldMac = " + this.oldMac;
        }
    }

    public static class PowerChanged
    extends PortEvent {
        public Boolean on;

        public PowerChanged(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.POWER_CHANGED;
            this.on = (Boolean)ltv.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\ton = " + this.on;
        }
    }
}

